from PyPDF2 import PdfReader, PdfWriter
from reportlab.lib.pagesizes import letter
from reportlab.pdfgen import canvas
import io

# 读取原始PDF文件
input_pdf_path = 'training_ppl_plot_ours_lion.pdf'
output_pdf_path = 'modified_training_ppl_plot_ours_lion.pdf'

reader = PdfReader(input_pdf_path)
writer = PdfWriter()

# 获取PDF的尺寸
page = reader.pages[0]
width = page.mediabox[2]
height = page.mediabox[3]

# 创建一个新的PDF画布来画线
packet = io.BytesIO()
can = canvas.Canvas(packet, pagesize=letter)
can.setStrokeColorRGB(1, 0, 0)  # 设置线条颜色为红色
can.setLineWidth(1)  # 设置线条宽度
y_position = height / 2  # 在页面中间位置画线
can.line(0, y_position, width, y_position)  # 画线
can.save()

# 移动到包的开始，以便重新读取内容
packet.seek(0)

# 使用reportlab的内容覆盖原始PDF页面
new_pdf = PdfReader(packet)
for page_number, page in enumerate(reader.pages):
    page.merge_page(new_pdf.pages[0])
    writer.add_page(page)

# 写入新的PDF文件
with open(output_pdf_path, 'wb') as out:
    writer.write(out)

print(f'Modified PDF saved as {output_pdf_path}')
